//------------------------------------------------------------------------------
// File: cmn_loadscripts.cs
// Contains methods and data to load all scripts one at a time and upate the
// loading screen
//------------------------------------------------------------------------------

//-Script Paths-----------------------------------------------------------------
$ServerDefDirectory  = "assets/server/scripts/";
$ServerAIDirectory   = "assets/server/scripts/ai/";
$ServerTaskDirectory = "assets/server/scripts/tasks/";
$ServerCmdDirectory  = "assets/server/scripts/commands/";
$ServerFxDirectory   = "assets/server/scripts/effects/";
$CommonWW2Directory  = "common/ww2/";
$ClientGuiDirectory  = "assets/client/ui/";
$ClientDefDirectory  = "assets/client/scripts/";
$ClientTaskDirectory = "assets/client/scripts/tasks/";
$ClientSaveDirectory = "assets/client/scripts/saving/";
$ClientCmdDirectory  = "assets/client/scripts/commands/";

// AI
$ServerScriptAI[0]  = $ServerAIDirectory @ "AttackObject.cs";
$ServerScriptAI[1]  = $ServerAIDirectory @ "AttackUntilDead.cs";
$ServerScriptAI[2]  = $ServerAIDirectory @ "Die.cs";
$ServerScriptAI[3]  = $ServerAIDirectory @ "OpenDoor.cs";
$ServerScriptAI[4]  = $ServerAIDirectory @ "CloseDoor.cs";
$ServerScriptAI[5]  = $ServerAIDirectory @ "FadeIn.cs";
$ServerScriptAI[6]  = $ServerAIDirectory @ "FadeOut.cs";
$ServerScriptAI[7]  = $ServerAIDirectory @ "FollowObject.cs";
$ServerScriptAI[8]  = $ServerAIDirectory @ "GoToAnyBuilding.cs";
$ServerScriptAI[9]  = $ServerAIDirectory @ "GoToBuilding.cs";
$ServerScriptAI[10] = $ServerAIDirectory @ "GoToSpot.cs";
$ServerScriptAI[11] = $ServerAIDirectory @ "GoToSpotBandit.cs";
$ServerScriptAI[12] = $ServerAIDirectory @ "GoToTeamBuilding.cs";
$ServerScriptAI[13] = $ServerAIDirectory @ "Idle_Basic.cs";
$ServerScriptAI[14] = $ServerAIDirectory @ "MoveBackAndForth.cs";
$ServerScriptAI[15] = $ServerAIDirectory @ "MoveIntoAttackRange.cs";
$ServerScriptAI[16] = $ServerAIDirectory @ "RemoveFromGame.cs";
$ServerScriptAI[17] = $ServerAIDirectory @ "Wait.cs";
$ServerScriptAI[18] = $ServerAIDirectory @ "WaitUntilBuildingIsBuilt.cs";
$ServerScriptAI[19] = $ServerAIDirectory @ "GoToWork.cs";
$ServerScriptAI[20] = $ServerAIDirectory @ "DonWorkClothes.cs";
$ServerScriptAI[21] = $ServerAIDirectory @ "PickupItem.cs";
$ServerScriptAI[22] = $ServerAIDirectory @ "GoToHome.cs";
$ServerScriptAI[23] = $ServerAIDirectory @ "RepairBuilding.cs";
$ServerScriptAI[24] = $ServerAIDirectory @ "GoToWorkHotSpot.cs";
$ServerScriptAI[25] = $ServerAIDirectory @ "Work.cs";
$ServerScriptAI[26] = $ServerAIDirectory @ "UnmountHand.cs";
$ServerScriptAI[27] = $ServerAIDirectory @ "MakeWorkDecision.cs";
$ServerScriptAI[28] = $ServerAIDirectory @ "GatherWorkObject.cs";
$ServerScriptAI[29] = $ServerAIDirectory @ "GoToWorkObject.cs";
$ServerScriptAI[30] = $ServerAIDirectory @ "LeaveTown.cs";
$ServerScriptAI[31] = $ServerAIDirectory @ "CheckForThreat.cs";
$ServerScriptAI[32] = $ServerAIDirectory @ "AnalyzeThreat.cs";
$ServerScriptAI[33] = $ServerAIDirectory @ "MoveAwayFromThreat.cs";
$ServerScriptAI[34] = $ServerAIDirectory @ "BecomeCivilian.cs";
$ServerScriptAI[35] = $ServerAIDirectory @ "IdleTime.cs";
$ServerScriptAI[36] = $ServerAIDirectory @ "GoToNearbySpot.cs";
$ServerScriptAI[37] = $ServerAIDirectory @ "PlaceDynamite.cs";
$ServerScriptAI[38] = $ServerAIDirectory @ "FallDown.cs";
$ServerScriptAI[39] = $ServerAIDirectory @ "GetUp.cs";
$ServerScriptAI[40] = $ServerAIDirectory @ "Heal.cs";
$ServerScriptAI[41] = $ServerAIDirectory @ "WaitUntilThreatPasses.cs";
$ServerScriptAI[42] = $ServerAIDirectory @ "FirePanic.cs";
$ServerScriptAI[43] = $ServerAIDirectory @ "GoToWell.cs";
$ServerScriptAI[44] = $ServerAIDirectory @ "ThrowWater.cs";
$ServerScriptAI[45] = $ServerAIDirectory @ "GoNearBuilding.cs";
$ServerScriptAI[46] = $ServerAIDirectory @ "BanditAttackUntilNearDead.cs";
$ServerScriptAI[47] = $ServerAIDirectory @ "BanditAttackInitialize.cs";
$ServerScriptAI[48] = $ServerAIDirectory @ "RandomPause.cs";
$ServerScriptAI[49] = $ServerAIDirectory @ "BecomeDrunk.cs";
$ServerScriptAI[50] = $ServerAIDirectory @ "DrunkIdle.cs";
$ServerScriptAI[51] = $ServerAIDirectory @ "Drink.cs";
$ServerScriptAI[52] = $ServerAIDirectory @ "Sway.cs";
$ServerScriptAI[53] = $ServerAIDirectory @ "VisitSaloon.cs";
$ServerScriptAI[54] = $ServerAIDirectory @ "VisitOuthouse.cs";
$ServerScriptAI[55] = $ServerAIDirectory @ "VisitJail.cs";
$ServerScriptAI[56] = $ServerAIDirectory @ "VisitWoodhut.cs";
$ServerScriptAI[57] = $ServerAIDirectory @ "WaitInJail.cs";
$ServerScriptAI[58] = $ServerAIDirectory @ "WaitUntilTargetVisible.cs";
$ServerScriptAI[59] = $ServerAIDirectory @ "Reaction_Defeated.cs";
$ServerScriptAI[60] = $ServerAIDirectory @ "Reaction_Attack.cs";
$ServerScriptAI[61] = $ServerAIDirectory @ "Monitor_Health.cs";
$ServerScriptAI[62] = $ServerAIDirectory @ "Monitor_Threats.cs";
$ServerScriptAI[63] = $ServerAIDirectory @ "Monitor_Actions.cs";
$ServerScriptAI[64] = $ServerAIDirectory @ "Reaction_AttackAttacker.cs";
$ServerScriptAI[65] = $ServerAIDirectory @ "Reaction_AttackAllyEnemy.cs";
$ServerScriptAI[66] = $ServerAIDirectory @ "Reaction_AttackSeenEnemy.cs";
$ServerScriptAI[67] = $ServerAIDirectory @ "Reaction_RunAway.cs";
$ServerScriptAI[68] = $ServerAIDirectory @ "BecomeNotAttackable.cs";
$ServerScriptAI[69] = $ServerAIDirectory @ "BecomeAttackable.cs";
$ServerScriptAI[70] = $ServerAIDirectory @ "UseWorkAI.cs";
$ServerScriptAI[71] = $ServerAIDirectory @ "CarryLumberToWork.cs";
$ServerScriptAI[72] = $ServerAIDirectory @ "PlayDefeatedSound.cs";
$ServerScriptAI[73] = $ServerAIDirectory @ "ReturnToSpawnPoint.cs";
$ServerScriptAI[74] = $ServerAIDirectory @ "Null.cs";
$ServerScriptAI[75] = $ServerAIDirectory @ "BanditWait.cs";
$ServerScriptAI[76] = $ServerAIDirectory @ "HungerDeath.cs";
$ServerScriptAI[77] = $ServerAIDirectory @ "PicketStart.cs";
$ServerScriptAI[78] = $ServerAIDirectory @ "Picket.cs";
$ServerScriptAI[79] = $ServerAIDirectory @ "WaitForTarget.cs";
$ServerScriptAI[80] = $ServerAIDirectory @ "VisitBuilding.cs";
$ServerScriptAI[81] = $ServerAIDirectory @ "StartGoToJail.cs";
$ServerScriptAI[82] = $ServerAIDirectory @ "RemoveFromSelection.cs";
$ServerScriptAI[83] = $ServerAIDirectory @ "MonitorHunger.cs";
$ServerScriptAI[84] = $ServerAIDirectory @ "MonitorHome.cs";
$ServerScriptAI[85] = $ServerAIDirectory @ "MonitorJob.cs";
$ServerScriptAI[86] = $ServerAIDirectory @ "GoNearObject.cs";
$ServerScriptAI[87] = $ServerAIDirectory @ "AINodeList.cs";
$ServerScriptAI[88] = $ServerAIDirectory @ "VisitRanch.cs";
$ServerScriptAI[89] = $ServerAIDirectory @ "CarryMeatToWork.cs";
$ServerScriptAI[90] = $ServerAIDirectory @ "VisitBank.cs";
$ServerScriptAI[91] = $ServerAIDirectory @ "CarryGoldToWork.cs";
$ServerScriptAI[92] = $ServerAIDirectory @ "VisitStore.cs";
$ServerScriptAI[93] = $ServerAIDirectory @ "CarryKegToWork.cs";
$ServerScriptAITotal   = 94;
$ServerScriptAICurrent = 0;

// Commands
$ServerScriptCmd[0] = $ServerCmdDirectory @ "svr_cmdsystem.cs";
$ServerScriptCmd[1] = $ServerCmdDirectory @ "svr_cmdmethods.cs";
$ServerScriptCmd[2] = $ServerCmdDirectory @ "svr_cmdhud.cs";
$ServerScriptCmd[3] = $ServerCmdDirectory @ "svr_cmdupgrades.cs";
$ServerScriptCmd[4] = $ServerCmdDirectory @ "svr_cmdcomponent.cs";
$ServerScriptCmdTotal   = 5;
$ServerScriptCmdCurrent = 0;

$ClientScriptCmd[0] = $ClientCmdDirectory @ "client_cmdsystem.cs";
$ClientScriptCmd[1] = $ClientCmdDirectory @ "client_cmdcomponent.cs";
$ClientScriptCmd[2] = $ClientCmdDirectory @ "client_cmddrag.cs";
$ClientScriptCmd[3] = $ClientCmdDirectory @ "client_cmdhud.cs";
$ClientScriptCmd[4] = $ClientCmdDirectory @ "client_cmdinterpret.cs";
$ClientScriptCmd[5] = $ClientCmdDirectory @ "client_cmdstates.cs";
$ClientScriptCmd[6] = $ClientCmdDirectory @ "client_cmdstatetracker.cs";
$ClientScriptCmd[7] = $ClientCmdDirectory @ "client_cmdupgrades.cs";
$ClientScriptCmd[8] = $ClientCmdDirectory @ "client_cmddisable.cs";
$ClientScriptCmdTotal   = 9;
$ClientScriptCmdCurrent = 0;

// Tasks
$ServerScriptTask[0]  = $ServerTaskDirectory @ "svr_tasksystem.cs";
$ServerScriptTask[1]  = $ServerTaskDirectory @ "svr_taskhelpers.cs";
$ServerScriptTask[2]  = $ServerTaskDirectory @ "svr_taskinfoarray.cs";
$ServerScriptTask[3]  = $ServerTaskDirectory @ "svr_taskmatches.cs";
$ServerScriptTask[4]  = $ServerTaskDirectory @ "svr_taskruler.cs";
$ServerScriptTask[5]  = $ServerTaskDirectory @ "svr_taskvertex.cs";
$ServerScriptTask[6]  = $ServerTaskDirectory @ "task_buildingEXP.cs";
$ServerScriptTask[7]  = $ServerTaskDirectory @ "GeneralTasks.cs";
$ServerScriptTask[8]  = $ServerTaskDirectory @ "BadgeTasks.cs";
$ServerScriptTask[9]  = $ServerTaskDirectory @ "HappyTasks.cs";
$ServerScriptTask[10] = $ServerTaskDirectory @ "Herostats.cs";
$ServerScriptTask[11] = $ServerTaskDirectory @ "TombstoneTask.cs";
$ServerScriptTask[12] = $ServerTaskDirectory @ "TutorialTasks.cs";
$ServerScriptTask[13] = $ServerTaskDirectory @ "StartTasks.cs";
$ServerScriptTask[14] = $ServerTaskDirectory @ "SandboxTasks.cs";
$ServerScriptTask[15] = $ServerTaskDirectory @ "mainmapTasks.cs";
$ServerScriptTask[16] = $ServerTaskDirectory @ "Combatrescue.cs";
$ServerScriptTask[17] = $ServerTaskDirectory @ "FireTutorial.cs";
$ServerScriptTask[18] = $ServerTaskDirectory @ "BridgeTutorial.cs";
$ServerScriptTask[19] = $ServerTaskDirectory @ "MarionTasks.cs";
$ServerScriptTask[20] = $ServerTaskDirectory @ "BridgeDefense.cs";
$ServerScriptTask[21] = $ServerTaskDirectory @ "BadSeed.cs";
$ServerScriptTask[22] = $ServerTaskDirectory @ "TownHallDefense.cs";
$ServerScriptTask[23] = $ServerTaskDirectory @ "DeadMine.cs";
$ServerScriptTask[24] = $ServerTaskDirectory @ "Escort.cs";
$ServerScriptTask[25] = $ServerTaskDirectory @ "SnakeValley.cs";
$ServerScriptTask[26] = $ServerTaskDirectory @ "SpyPuzzle.cs";
$ServerScriptTask[27] = $ServerTaskDirectory @ "OutpostGold.cs";
$ServerScriptTask[28] = $ServerTaskDirectory @ "OutpostWood.cs";
$ServerScriptTask[29] = $ServerTaskDirectory @ "OutpostFood.cs";
$ServerScriptTask[30] = $ServerTaskDirectory @ "Famine.cs";
$ServerScriptTask[31] = $ServerTaskDirectory @ "MadRussian.cs";
$ServerScriptTask[32] = $ServerTaskDirectory @ "OutpostTasks.cs";
$ServerScriptTask[33] = $ServerTaskDirectory @ "WhiteWong.cs";
$ServerScriptTask[34] = $ServerTaskDirectory @ "FoodBaker.cs";
$ServerScriptTask[35] = $ServerTaskDirectory @ "campaign2.cs";
$ServerScriptTask[36] = $ServerTaskDirectory @ "GlobalTasks.cs";
$ServerScriptTask[37] = $ServerTaskDirectory @ "FinalShowdown.cs";
$ServerScriptTask[38] = $ServerTaskDirectory @ "GeneralStoreTasks.cs";
$ServerScriptTask[39] = $ServerTaskDirectory @ "TornadoValley.cs";
$ServerScriptTask[40] = $ServerTaskDirectory @ "AnimalTrap.cs";
$ServerScriptTaskTotal   = 41;
$ServerScriptTaskCurrent = 0;

$ClientScriptTask[0]  = $ClientTaskDirectory @ "client_tasksystem.cs";
$ClientScriptTask[1]  = $ClientTaskDirectory @ "client_tasklistener.cs";
$ClientScriptTask[2]  = $ClientTaskDirectory @ "client_taskstrings.cs";
$ClientScriptTask[3]  = $ClientTaskDirectory @ "client_taskstringtable.cs";
$ClientScriptTask[4]  = $ClientTaskDirectory @ "client_tasksvrcmds.cs";
$ClientScriptTaskTotal   = 5;
$ClientScriptTaskCurrent = 0;

// Light
$ServerScriptLight[0] = "common/server/lightingSystem.cs";
$ServerScriptLightTotal   = 1;
$ServerScriptLightCurrent = 0;
   
// Fx
$ServerScriptFx[0] = $ServerFxDirectory @ "effects.cs";
$ServerScriptFx[1] = $ServerFxDirectory @ "smoke.cs";
$ServerScriptFx[2] = $ServerFxDirectory @ "buildingeffects.cs";
$ServerScriptFx[3] = $ServerFxDirectory @ "fire.cs";
$ServerScriptFx[4] = $ServerFxDirectory @ "explosion.cs";
$ServerScriptFx[5] = $ServerFxDirectory @ "treeleaves.cs";
$ServerScriptFx[6] = $ServerFxDirectory @ "pickupeffects.cs";
$ServerScriptFx[7] = $ServerFxDirectory @ "combat.cs";
$ServerScriptFxTotal   = 8;
$ServerScriptFxCurrent = 0;

// Miscellaneous
$ServerScriptMisc[0]  = $ServerDefDirectory @ "svr_gamemode.cs";
$ServerScriptMisc[1]  = $ServerDefDirectory @ "svr_heroselect.cs";
$ServerScriptMisc[2]  = $ServerDefDirectory @ "slgameobjects/svr_slgameobjmods.cs";
$ServerScriptMisc[3]  = $ServerDefDirectory @ "borderProps.cs";
$ServerScriptMisc[4]  = $ServerDefDirectory @ "SLCommon.cs";
$ServerScriptMisc[5]  = $ServerDefDirectory @ "audioProfiles.cs";
$ServerScriptMisc[6]  = $ServerDefDirectory @ "svr_camera.cs";
$ServerScriptMisc[7]  = $ServerDefDirectory @ "resources.cs";
$ServerScriptMisc[8]  = $ServerDefDirectory @ "shapeBase.cs";
$ServerScriptMisc[9]  = $ServerDefDirectory @ "staticShape.cs";
$ServerScriptMisc[10] = $ServerDefDirectory @ "triggers.cs";
$ServerScriptMisc[11] = $ServerDefDirectory @ "SLEffects.cs";
$ServerScriptMisc[12] = $ServerDefDirectory @ "SLProps.cs";
$ServerScriptMisc[13] = $ServerDefDirectory @ "SLCharacters.cs";
$ServerScriptMisc[14] = $ServerDefDirectory @ "SLBuildings.cs";
$ServerScriptMisc[15] = $ServerDefDirectory @ "imageprops.cs";
$ServerScriptMisc[16] = $ServerDefDirectory @ "svr_building.cs";
$ServerScriptMisc[17] = $ServerDefDirectory @ "svr_character.cs";
$ServerScriptMisc[18] = $ServerDefDirectory @ "svr_prop.cs";
$ServerScriptMisc[19] = $ServerDefDirectory @ "svr_resources.cs";
$ServerScriptMisc[20] = $ServerDefDirectory @ "svr_experience.cs";
$ServerScriptMisc[21] = $ServerDefDirectory @ "svr_disaster.cs";
$ServerScriptMisc[22] = $ServerDefDirectory @ "svr_scenario.cs";
$ServerScriptMisc[23] = $ServerDefDirectory @ "svr_carryover.cs";
$ServerScriptMisc[24] = $ServerDefDirectory @ "svr_inventory.cs";
$ServerScriptMisc[25] = $ServerDefDirectory @ "svr_tools.cs";
$ServerScriptMisc[26] = $ServerDefDirectory @ "svr_linkobject.cs";
$ServerScriptMisc[27] = $ServerDefDirectory @ "techs/svr_tech.cs";
$ServerScriptMisc[28] = $ServerDefDirectory @ "svr_parade.cs";
$ServerScriptMisc[29] = $ServerDefDirectory @ "svr_alerts.cs";
$ServerScriptMisc[30] = $ServerDefDirectory @ "svr_happymods.cs";
$ServerScriptMisc[31] = $ServerDefDirectory @ "svr_destflag.cs";
$ServerScriptMisc[32] = $ServerDefDirectory @ "svr_statGui.cs";
$ServerScriptMisc[33] = $ServerDefDirectory @ "saving/svr_savebuilding.cs";
$ServerScriptMisc[34] = $ServerDefDirectory @ "saving/svr_savecharacter.cs";
$ServerScriptMisc[35] = $ServerDefDirectory @ "saving/svr_saveprop.cs";
$ServerScriptMisc[36] = $ServerDefDirectory @ "saving/svr_saveobject.cs";
$ServerScriptMisc[37] = $ServerDefDirectory @ "saving/svr_savealerts.cs";
$ServerScriptMisc[38] = $ServerDefDirectory @ "saving/svr_saveai.cs";
$ServerScriptMisc[39] = $ServerDefDirectory @ "saving/svr_savetaskbuttons.cs";

$ServerScriptMisc[40] = $ServerDefDirectory @ "audio/svr_banker_audio.cs";
$ServerScriptMisc[41] = $ServerDefDirectory @ "audio/svr_bh_sheriff_audio.cs";
$ServerScriptMisc[42] = $ServerDefDirectory @ "audio/svr_deputy_audio.cs";
$ServerScriptMisc[43] = $ServerDefDirectory @ "audio/svr_f_bandit_audio.cs";
$ServerScriptMisc[44] = $ServerDefDirectory @ "audio/svr_f_civilian_audio.cs";
$ServerScriptMisc[45] = $ServerDefDirectory @ "audio/svr_f_drunk_audio.cs";
$ServerScriptMisc[46] = $ServerDefDirectory @ "audio/svr_farmer_audio.cs";
$ServerScriptMisc[47] = $ServerDefDirectory @ "audio/svr_female_gunslinger_audio.cs";
$ServerScriptMisc[48] = $ServerDefDirectory @ "audio/svr_hunter_audio.cs";
$ServerScriptMisc[49] = $ServerDefDirectory @ "audio/svr_m_bandit_audio.cs";
$ServerScriptMisc[50] = $ServerDefDirectory @ "audio/svr_m_civilian_audio.cs";
$ServerScriptMisc[51] = $ServerDefDirectory @ "audio/svr_m_drunk_audio.cs";
$ServerScriptMisc[52] = $ServerDefDirectory @ "audio/svr_male_bh_gunslinger_audio.cs";
$ServerScriptMisc[53] = $ServerDefDirectory @ "audio/svr_male_n_gunslinger_audio.cs";
$ServerScriptMisc[54] = $ServerDefDirectory @ "audio/svr_male_wh_gunslinger_audio.cs";
$ServerScriptMisc[55] = $ServerDefDirectory @ "audio/svr_russian_audio.cs";
$ServerScriptMisc[56] = $ServerDefDirectory @ "audio/svr_wh_sheriff_audio.cs";
$ServerScriptMisc[57] = $ServerDefDirectory @ "audio/svr_white_audio.cs";
$ServerScriptMisc[58] = $ServerDefDirectory @ "audio/svr_wong_audio.cs";
$ServerScriptMisc[59] = $ServerDefDirectory @ "audio/svr_yeti_audio.cs";
$ServerScriptMisc[60] = $ServerDefDirectory @ "audio/svr_bear_audio.cs";
$ServerScriptMiscTotal   = 61;
$ServerScriptMiscCurrent = 0;

$ClientScriptSave[0] = $ClientSaveDirectory @ "client_savebuilding.cs";
$ClientScriptSave[1] = $ClientSaveDirectory @ "client_saveobject.cs";
$ClientScriptSave[2] = $ClientSaveDirectory @ "client_savealerts.cs";
$ClientScriptSave[3] = $ClientSaveDirectory @ "client_savequesthud.cs";
$ClientScriptSave[4] = $ClientSaveDirectory @ "client_savequestgui.cs";
$ClientScriptSave[5] = $ClientSaveDirectory @ "client_savetaskbuttons.cs";
$ClientScriptSaveTotal   = 6;
$ClientScriptSaveCurrent = 0;

$ClientScriptMisc[0]  = $ClientDefDirectory @ "client_game.cs";
$ClientScriptMisc[1]  = $ClientDefDirectory @ "client_questHud.cs";
$ClientScriptMisc[2]  = $ClientDefDirectory @ "client_questGui.cs";
$ClientScriptMisc[3]  = $ClientDefDirectory @ "gameOptions.cs";
$ClientScriptMisc[4]  = $ClientDefDirectory @ "playGui.cs";
$ClientScriptMisc[5]  = $ClientDefDirectory @ "client_menu.cs";
$ClientScriptMisc[6]  = $ClientDefDirectory @ "client_experience.cs";
$ClientScriptMisc[7]  = $ClientDefDirectory @ "client_messageHud.cs";
$ClientScriptMisc[8]  = $ClientDefDirectory @ "client_alerts.cs";
$ClientScriptMisc[9]  = $ClientDefDirectory @ "client_targetGuis.cs";
$ClientScriptMisc[10] = $ClientDefDirectory @ "client_hudbuttons.cs";
$ClientScriptMisc[11] = $ClientDefDirectory @ "client_inventory.cs";
$ClientScriptMisc[12] = $ClientDefDirectory @ "client_tools.cs";
$ClientScriptMisc[13] = $ClientDefDirectory @ "client_button.cs";
$ClientScriptMisc[14] = $ClientDefDirectory @ "client_taskDialogGui.cs";
$ClientScriptMisc[15] = $ClientDefDirectory @ "client_linkobject.cs";
$ClientScriptMisc[16] = $ClientDefDirectory @ "client_statGui.cs";
$ClientScriptMisc[17] = $ClientDefDirectory @ "client_slgameobj.cs";
$ClientScriptMisc[18] = $ClientDefDirectory @ "client_building.cs";
$ClientScriptMisc[19] = $ClientDefDirectory @ "client_character.cs";
$ClientScriptMisc[20] = $ClientDefDirectory @ "client_prop.cs";
$ClientScriptMiscTotal   = 21;
$ClientScriptMiscCurrent = 0;
   
// Common scripts
$CommonScriptWW2[0]  = $CommonWW2Directory @ "cmn_camera.cs";
$CommonScriptWW2[1]  = $CommonWW2Directory @ "cmn_gamemode.cs";
$CommonScriptWW2[2]  = $CommonWW2Directory @ "cmn_heroselect.cs";
$CommonScriptWW2[3]  = $CommonWW2Directory @ "cmn_msgsystem.cs";
$CommonScriptWW2[4]  = $CommonWW2Directory @ "cmn_slgameobjlist.cs";
$CommonScriptWW2[5]  = $CommonWW2Directory @ "cmn_slgameobj.cs";
$CommonScriptWW2[6]  = $CommonWW2Directory @ "cmn_arrayargs.cs";
$CommonScriptWW2[7]  = $CommonWW2Directory @ "cmn_lights.cs";
$CommonScriptWW2[8]  = $CommonWW2Directory @ "cmn_math.cs";
$CommonScriptWW2[9]  = $CommonWW2Directory @ "cmn_resources.cs";
$CommonScriptWW2[10] = $CommonWW2Directory @ "cmn_cmdsystem.cs";
$CommonScriptWW2[11] = $CommonWW2Directory @ "cmn_inventory.cs";
$CommonScriptWW2[12] = $CommonWW2Directory @ "cmn_alerts.cs";
$CommonScriptWW2[13] = $CommonWW2Directory @ "cmn_happymods.cs";
$CommonScriptWW2[14] = $CommonWW2Directory @ "cmn_badges.cs";
$CommonScriptWW2[15] = $CommonWW2Directory @ "cmn_cheats.cs";
$CommonScriptWW2Total   = 16;
$CommonScriptWW2Current = 0;

// Gui scripts
$ClientScriptGui[0]  = $ClientGuiDirectory @ "PlayGui.gui";
$ClientScriptGui[1]  = $ClientGuiDirectory @ "ExperienceGui.gui";
$ClientScriptGui[2]  = $ClientGuiDirectory @ "mainMenuGui.gui";
$ClientScriptGui[3]  = $ClientGuiDirectory @ "gameMenuGui.gui";
$ClientScriptGui[4]  = $ClientGuiDirectory @ "gameOptionsGui.gui";
$ClientScriptGui[5]  = $ClientGuiDirectory @ "gameOverwriteGui.gui";
$ClientScriptGui[6]  = $ClientGuiDirectory @ "gameQuitGui.gui";
$ClientScriptGui[7]  = $ClientGuiDirectory @ "selectCharacterGui.gui";
$ClientScriptGui[8]  = $ClientGuiDirectory @ "profileStart.gui";
$ClientScriptGui[9]  = $ClientGuiDirectory @ "createProfile.gui";
$ClientScriptGui[10] = $ClientGuiDirectory @ "notificationGui.gui";
$ClientScriptGui[11] = $ClientGuiDirectory @ "tutorialselectgui.gui";
$ClientScriptGui[12] = $ClientGuiDirectory @ "saveGameGui.gui";
$ClientScriptGui[13] = $ClientGuiDirectory @ "loadGameGui.gui";
$ClientScriptGui[14] = $ClientGuiDirectory @ "GameSavingGui.gui";
$ClientScriptGui[15] = $ClientGuiDirectory @ "GameLoadingGui.gui";
$ClientScriptGui[16] = $ClientGuiDirectory @ "taskDialogGui.gui";
$ClientScriptGui[17] = $ClientGuiDirectory @ "statGui.gui";
$ClientScriptGui[18] = $ClientGuiDirectory @ "disableGui.gui";
$ClientScriptGui[19] = $ClientGuiDirectory @ "badgeGui.gui";
$ClientScriptGui[20] = $ClientGuiDirectory @ "EndScenarioGui.gui";
$ClientScriptGui[21] = $ClientGuiDirectory @ "QuestScreenGui.gui";
$ClientScriptGui[22] = $ClientGuiDirectory @ "DeleteProfileGui.gui";
$ClientScriptGui[23] = $ClientGuiDirectory @ "CreditsGui.gui";
$ClientScriptGui[24] = $ClientGuiDirectory @ "WorldMapGui.gui";
$ClientScriptGui[25] = $ClientGuiDirectory @ "SandboxMapGui.gui";
$ClientScriptGui[26] = $ClientGuiDirectory @ "ExitGameGui.gui";
$ClientScriptGuiTotal   = 27;
$ClientScriptGuiCurrent = 0;

$ScriptTotal   = $ServerScriptAITotal + $ServerScriptCmdTotal + 
                 $ClientScriptCmdTotal + $ServerScriptTaskTotal + 
                 $ClientScriptTaskTotal + $ServerScriptLightTotal + 
                 $ServerScriptFxTotal + $ServerScriptMiscTotal + 
                 $ClientScriptSaveTotal + $ClientScriptMiscTotal +
                 $CommonScriptWW2Total + $ClientScriptGuiTotal;
$ScriptCurrent = 0;
//------------------------------------------------------------------------------

   
//-Functions-------------------------------------------------------------------
function loadNextScript()
{
   /**** COMMON ****/
   // Load common scripts first
   if($CommonScriptWW2Current < $CommonScriptWW2Total) {
      exec($CommonScriptWW2[$CommonScriptWW2Current]);
      $CommonScriptWW2Current++;
      $ScriptCurrent++;
   }
   
   /**** SERVER ****/
   // Load next AI script
   else if($ServerScriptAICurrent < $ServerScriptAITotal) {
      exec($ServerScriptAI[$ServerScriptAICurrent]);
      $ServerScriptAICurrent++;
      $ScriptCurrent++;
   }
   
   // Load next command script   
   else if($ServerScriptCmdCurrent < $ServerScriptCmdTotal) {
      exec($ServerScriptCmd[$ServerScriptCmdCurrent]);
      $ServerScriptCmdCurrent++;
      $ScriptCurrent++;
   }
   
   // Load next task script
   else if($ServerScriptTaskCurrent < $ServerScriptTaskTotal) {
      exec($ServerScriptTask[$ServerScriptTaskCurrent]);
      $ServerScriptTaskCurrent++;
      $ScriptCurrent++;
   }
   
   // Load next lighting script
   else if($ServerScriptLightCurrent < $ServerScriptLightTotal) {
      exec($ServerScriptLight[$ServerScriptLightCurrent]);
      $ServerScriptLightCurrent++;
      $ScriptCurrent++;
   }
   
   // Load next fx script
   else if($ServerScriptFxCurrent < $ServerScriptFxTotal) {
      exec($ServerScriptFx[$ServerScriptFxCurrent]);
      $ServerScriptFxCurrent++;
      $ScriptCurrent++;
   }
   
   // Load next misc script
   else if($ServerScriptMiscCurrent < $ServerScriptMiscTotal) {
      exec($ServerScriptMisc[$ServerScriptMiscCurrent]);
      $ServerScriptMiscCurrent++;
      $ScriptCurrent++;
   }
   
   /**** CLIENT ****/
   // Load next gui script
    else if($ClientScriptGuiCurrent < $ClientScriptGuiTotal) {
      exec($ClientScriptGui[$ClientScriptGuiCurrent]);
      $ClientScriptGuiCurrent++;
      $ScriptCurrent++;
   }
   
   // Load next task script
   else if($ClientScriptTaskCurrent < $ClientScriptTaskTotal) {
      exec($ClientScriptTask[$ClientScriptTaskCurrent]);
      $ClientScriptTaskCurrent++;
      $ScriptCurrent++;
   }
   
   // Load next command script
   else if($ClientScriptCmdCurrent < $ClientScriptCmdTotal) {
      exec($ClientScriptCmd[$ClientScriptCmdCurrent]);
      $ClientScriptCmdCurrent++;
      $ScriptCurrent++;
   }
   
   // Load next save script
   else if($ClientScriptSaveCurrent < $ClientScriptSaveTotal) {
      exec($ClientScriptSave[$ClientScriptSaveCurrent]);
      $ClientScriptSaveCurrent++;
      $ScriptCurrent++;
   }
   
   // Load next misc script
   else if($ClientScriptMiscCurrent < $ClientScriptMiscTotal) {
      exec($ClientScriptMisc[$ClientScriptMiscCurrent]);
      $ClientScriptMiscCurrent++;
      $ScriptCurrent++;
   }
   
   // We are done
   else {
      return true;
   }
   
   onScriptProgress($ScriptCurrent / $ScriptTotal);
   return false;
}
//------------------------------------------------------------------------------

// End cmn_loadscripts.cs
